#ifndef _PACKAGE_CPP
#define _PACKAGE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <IO.H>
#include <ShlOBJ.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "../Headers/NSWFL.H"
#include "../Headers/NASCCL.H"
#include "../Headers/Package.H"
#include "../Headers/Entry.H"
#include "../Headers/IndexDir.H"
#include "../Headers/CRC32.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/OpenPassDlg.H"
#include "../Dialogs/ReadingDlg.H"
#include "../Dialogs/PackingDlg.H"
#include "../Dialogs/ExtractDlg.H"

#include "../LZSS/LZSS_Compress.H"
#include "../LZSS/LZSS_Uncompress.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD PackageProgress = 0;
DWORD Worker_Thread_ID = 0;
HANDLE Worker_Thread_Handle = NULL;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetIconForExt(char *inExt, char *outIconFile, int *outIconIndex, char *outDescr)
{
    char lsKey[256];
    char lsDefaultIcon[256];
    char lsTempKey[256];
    char Temp[256];
    DWORD dwBufferLen = 256;

    memset(lsKey, 0, sizeof(lsKey));
    memset(lsTempKey, 0, sizeof(lsTempKey));
    memset(lsDefaultIcon, 0, sizeof(lsDefaultIcon));

    dwBufferLen = 256;
    if(!Get_StringRegistryValue(HKEY_CLASSES_ROOT, inExt, NULL, lsKey, dwBufferLen))
        return false;

    dwBufferLen = 256;
    if(!Get_StringRegistryValue(HKEY_CLASSES_ROOT, lsKey, NULL, outDescr, dwBufferLen))
        return false;

    dwBufferLen = 256;
    sprintf(lsTempKey, "%s\\DefaultIcon", lsKey);
    if(!Get_StringRegistryValue(HKEY_CLASSES_ROOT, lsTempKey, NULL, lsDefaultIcon, dwBufferLen))
        return false;

    int RPos = strlen(lsDefaultIcon) - 1;
    int WPos = 0;

    while(RPos > 1)
    {
        if(lsDefaultIcon[RPos] != ' ' && lsDefaultIcon[RPos] != '\t')
        {
            if(lsDefaultIcon[RPos] == ',')
            {
                lsDefaultIcon[RPos] = '\0';
                break;
            }

            if(!(lsDefaultIcon[RPos] >= '0' && lsDefaultIcon[RPos] <= '9') && lsDefaultIcon[RPos] != '-')
            {
                break;
            }

            Temp[WPos] = lsDefaultIcon[RPos];
            WPos++;
        }

        RPos--;
    }

    if(WPos > 0)
    {
        ReverseString(Temp, WPos);
        *outIconIndex = atoi(Temp);
    }

    strcpy(outIconFile, lsDefaultIcon);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char *FormatiString(char *outStr, char *inStr)
{
    int RPos = strlen(inStr) - 1;
    int WPos = 0;
    int DPos = 0;

    if(RPos < 3)
        return inStr;

    while(RPos != -1)
    {
        if(DPos == 3)
        {
            outStr[WPos++] = ',';
            DPos = 0;
        }

        outStr[WPos] = inStr[RPos];

        RPos--;
        WPos++;
        DPos++;
    }

    ReverseString(outStr, WPos);

    outStr[WPos] = '\0';

    return outStr;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CreateFolderStructure(char *FullFileName)
{
    char Directory[256];

    int NameLength = strlen(FullFileName);
    int Position = 0;

    while(Position < NameLength)
    {
        if(FullFileName[Position] == '\\' || FullFileName[Position] == '/')
        {
            Directory[Position] = '\0';
            CreateDirectory(Directory, NULL);
        }

        Directory[Position] = FullFileName[Position];

        Position++;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

long MakeChecksum(char *RawKey)
{
    char KeyHash[CHECKSUMLEN + 1];
    int RPos = 0;
    long Checksum = 0;

    HashKey(RawKey, KeyHash, strlen(RawKey), CHECKSUMLEN);

    while(RPos < CHECKSUMLEN)
    {
        Checksum = (Checksum + KeyHash[RPos]);
        RPos++;
    }

    return Checksum;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool MakePackage(char *SrcFolder, char *TarName, char *RawKey, int RawKeyLen)
{
    char FullFileName[256];
    char StatusText[1024 + 1];
    char TempBuf[1024];
    DWORD BytesRead = 0;
    DWORD BytesWritten = 0;
    DWORD CompressedFileSize = 0;
    DWORD CompSeekPos = 0;
    DWORD CurrentFPointer = 0;
    DWORD DeflSize = 0;
    DWORD FileCount = 0;
    DWORD FileSize = 0;
    FILETIME CreationTime;
    FILETIME LastWriteTime;
    HANDLE hfSource = NULL;
    HANDLE hfTarget = NULL;
    int CompressResult = 0;
    long Checksum1 = 0;
    long Checksum2 = 0;
    unsigned char *SourceBuf = NULL;
    unsigned char *TargetBuf = NULL;
    unsigned long FinalCRC = 0;
    unsigned long LoopCount = 0;
    unsigned short FileNameLen = 0;

    _NASCCL NASCCL;
    FilePack MyFilePack;

	HS_LZSS_Compress MyLZSS_Compress;

    memset(&NASCCL, 0, sizeof(NASCCL));
    memset(TempBuf, 0, sizeof(TempBuf));

    MyFilePack.Initialize();

    MyFilePack.IndexDirectory(SrcFolder, strlen(SrcFolder));

    Sleep(1000);

    Animate_Close(Animation_hWnd);
    Animate_Open(Animation_hWnd, MAKEINTRESOURCE(IDR_ENCRYPTAVI));

    InitializeCryptographySet(&NASCCL, RawKey, RawKeyLen, CRYPTMETHOD);

    MyLZSS_Compress.SetupCompressionLevel(giCompressLevel);

    hfTarget = CreateFile(
        TarName,
        GENERIC_WRITE,
        0,
        NULL,
        CREATE_ALWAYS,
        FILE_ATTRIBUTE_NORMAL,
        NULL
    );

    if(hfTarget == INVALID_HANDLE_VALUE)
    {
        sprintf(StatusText, "Failed to open '%s' for write.", TarName);
        MessageBox(PackingDialog_hWnd, StatusText, gsTitleCaption, MB_ICONEXCLAMATION|MB_OK|MB_APPLMODAL);
        return false;
    }

    Checksum1 = MakeChecksum(RawKey);
    WriteFile(hfTarget, &Checksum1, sizeof(long), &BytesWritten, NULL);

	Checksum2 = HARDCHECKSUM;
    Encode(&NASCCL, (char *)&Checksum2, (char *)&Checksum2, sizeof(long));
    WriteFile(hfTarget, &Checksum2, sizeof(long), &BytesWritten, NULL);

    FileCount = MyFilePack.FileCount;
    Encode(&NASCCL, (char *)&FileCount, (char *)&FileCount, sizeof(DWORD));
    WriteFile(hfTarget, &FileCount, sizeof(DWORD), &BytesWritten, NULL);

    SendMessage(PackingStatusBar_hWnd, PBM_SETRANGE, 0, (LPARAM) MAKELPARAM(0, MyFilePack.FileCount));

    SourceBuf = (unsigned char *) calloc(BufferSize + 1, sizeof(char));
    TargetBuf = (unsigned char *) calloc((BufferSize + ExtraSize) + 1, sizeof(char));

	while(LoopCount < MyFilePack.FileCount)
    {
        strcpy(FullFileName, SrcFolder);
        strcat(FullFileName, MyFilePack.FileNames[LoopCount]);

        FileNameLen = strlen(MyFilePack.FileNames[LoopCount]);

        WriteFile(hfTarget, &FileNameLen, sizeof(unsigned short), &BytesWritten, NULL);
        Encode(&NASCCL, MyFilePack.FileNames[LoopCount], TempBuf, FileNameLen);
        WriteFile(hfTarget, TempBuf, FileNameLen, &BytesWritten, NULL);

        if(gdwCurrentJobType == JOB_TYPE_CANCEL)
        {
            Sleep(1000);
            break;
        }

        sprintf(StatusText, "Adding: %s", MyFilePack.FileNames[LoopCount]);
        Set_Text(PackingStatusText_hWnd, StatusText);

        hfSource = CreateFile(
            FullFileName,
            GENERIC_READ,
            FILE_SHARE_READ,
            NULL,
            OPEN_EXISTING,
            FILE_ATTRIBUTE_NORMAL,
            NULL
        );

        if(hfSource == INVALID_HANDLE_VALUE)
        {
            sprintf(StatusText, "Failed to open '%s' for read.", FullFileName);
            MessageBox(PackingDialog_hWnd, StatusText, gsTitleCaption, MB_ICONEXCLAMATION|MB_OK|MB_APPLMODAL);

            CloseHandle(hfTarget);
            free(SourceBuf);
            free(TargetBuf);
            return false;
        }

        GetFileTime(hfSource, &CreationTime, NULL, &LastWriteTime);

        FileSize = GetFileSize(hfSource, NULL);
        WriteFile(hfTarget, &FileSize, sizeof(DWORD), &BytesWritten, NULL);
        CompSeekPos = SetFilePointer(hfTarget, 0, NULL, FILE_CURRENT);
        WriteFile(hfTarget, &FileSize, sizeof(DWORD), &BytesWritten, NULL);
        WriteFile(hfTarget, &CreationTime, sizeof(FILETIME), &BytesWritten, NULL);
        WriteFile(hfTarget, &LastWriteTime, sizeof(FILETIME), &BytesWritten, NULL);

    	FinalCRC = 0xffffffff;

        bool bCompression = true;

        do{
            ReadFile(hfSource, SourceBuf, BufferSize, &BytesRead, NULL);

            FinalCRC = PartialCRC(FinalCRC, SourceBuf, BytesRead);

    		CompressResult = MyLZSS_Compress.Compress(SourceBuf, TargetBuf, BytesRead, &DeflSize);
            if(CompressResult != HS_LZSS_E_OK)
            {
                memcpy(TargetBuf, SourceBuf, BytesRead);
                DeflSize = BytesRead;
                bCompression = false;
                WriteFile(hfTarget, &bCompression, sizeof(bool), &BytesWritten, NULL);
            }
            else{
                bCompression = true;
                WriteFile(hfTarget, &bCompression, sizeof(bool), &BytesWritten, NULL);
            }

            TargetBuf[DeflSize] = '\0';
            Encode(&NASCCL, (char *)TargetBuf, (char *)TargetBuf, DeflSize);

            WriteFile(hfTarget, &BytesRead, sizeof(DWORD), &BytesWritten, NULL);
            WriteFile(hfTarget, &DeflSize, sizeof(DWORD), &BytesWritten, NULL);
            WriteFile(hfTarget, TargetBuf, DeflSize, &BytesWritten, NULL);

        } while(BytesRead == BufferSize);

        FinalCRC = (FinalCRC ^ 0xffffffff);

        CurrentFPointer = SetFilePointer(hfTarget, 0, NULL, FILE_CURRENT);
        CompressedFileSize = ((CurrentFPointer - CompSeekPos) - sizeof(DWORD));
        SetFilePointer(hfTarget, CompSeekPos, NULL, FILE_BEGIN);
        WriteFile(hfTarget, &CompressedFileSize, sizeof(DWORD), &BytesWritten, NULL);
        SetFilePointer(hfTarget, CurrentFPointer, NULL, FILE_BEGIN);
        WriteFile(hfTarget, &FinalCRC, sizeof(DWORD), &BytesWritten, NULL);

        CloseHandle(hfSource);

        LoopCount++;
        PackageProgress = LoopCount;
	}

    free(SourceBuf);
    free(TargetBuf);

	MyFilePack.FreeMemory();

    CloseHandle(hfTarget);

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool BreakPackage(char *SrcName, char *TarFolder, char *RawKey, int RawKeyLen)
{
    unsigned char *SourceBuf = NULL;
    unsigned char *TargetBuf = NULL;
    char FullFileName[256];
    char PartFileName[256];
    char TempBuf[1024];
    DWORD BytesRead = 0;
    DWORD FileCount = 0;
    DWORD BytesWritten = 0;
    DWORD CompressedFileSize = 0;
    DWORD DeflSize = 0;
    DWORD FileSize = 0;
    DWORD InflSize = 0;
    DWORD OrigSize = 0;
    FILETIME CreationTime;
    FILETIME LastWriteTime;
    HANDLE hfSource = NULL;
    HANDLE hfTarget = NULL;
    long Checksum = 0;
    long ReadChecksum1 = 0;
    long ReadChecksum2 = 0;
    unsigned long FinalCRC = 0;
    unsigned long LoopCount = 0;
    unsigned long ReadCRC = 0;
    unsigned short FileNameLen = 0;
    int CompressResult = 0;
    char StatusText[255 + 1];

    _NASCCL NASCCL;
	HS_LZSS_Uncompress MyLZSS_Uncompress;

    memset(&NASCCL, 0, sizeof(NASCCL));
    memset(TempBuf, 0, sizeof(TempBuf));

    InitializeCryptographySet(&NASCCL, RawKey, RawKeyLen, CRYPTMETHOD);

    Checksum = MakeChecksum(RawKey);

    hfSource = CreateFile(
        SrcName,
        GENERIC_READ,
        FILE_SHARE_READ,
        NULL,
        OPEN_EXISTING,
        FILE_ATTRIBUTE_NORMAL,
        NULL
    );

    if(hfSource == INVALID_HANDLE_VALUE)
    {
        sprintf(StatusText, "Failed to open '%s' for read.", SrcName);
        MessageBox(PackingDialog_hWnd, StatusText, gsTitleCaption, MB_ICONEXCLAMATION|MB_OK|MB_APPLMODAL);
        return false;
    }

    ReadFile(hfSource, &ReadChecksum1, sizeof(long), &BytesRead, NULL);
    ReadFile(hfSource, &ReadChecksum2, sizeof(long), &BytesRead, NULL);
    Decode(&NASCCL, (char *)&ReadChecksum2, (char *)&ReadChecksum2, sizeof(long));

    if(ReadChecksum1 != Checksum || ReadChecksum2 != HARDCHECKSUM)
    {
        MessageBox(PackingDialog_hWnd, "Wrong key, Can't decrypt.", gsTitleCaption, MB_ICONINFORMATION|MB_OK|MB_APPLMODAL);
        CloseHandle(hfSource);
        return false;
    }

    ReadFile(hfSource, &FileCount, sizeof(DWORD), &BytesRead, NULL);
    Decode(&NASCCL, (char *)&FileCount, (char *)&FileCount, sizeof(DWORD));
    SendMessage(PackingStatusBar_hWnd, PBM_SETRANGE, 0, (LPARAM) MAKELPARAM(0, FileCount));

    PackageProgress = 0;

    SourceBuf = (unsigned char *) calloc((BufferSize + ExtraSize) + 1, sizeof(char));
    TargetBuf = (unsigned char *) calloc((BufferSize + ExtraSize) + 1, sizeof(char));

    //--------------------------------------------------------------------------------

    ReadFile(hfSource, &FileNameLen, sizeof(unsigned short), &BytesRead, NULL);

    char LVFileName[255 + 1];
    char LVFullFileName[255 + 1];
    char LVPath[255 + 1];

    do{
        if(FileNameLen <= 0 || FileNameLen > 255)
        {
            sprintf(StatusText, "Corrupt data file. Name length: %d", FileNameLen);
            MessageBox(PackingDialog_hWnd, StatusText, gsTitleCaption, MB_ICONEXCLAMATION|MB_OK|MB_APPLMODAL);
            break;
        }

        ReadFile(hfSource, PartFileName, FileNameLen, &BytesRead, NULL);
        Decode(&NASCCL, PartFileName, PartFileName, FileNameLen);
    	PartFileName[FileNameLen] = '\0';
        ReadFile(hfSource, &FileSize, sizeof(DWORD), &BytesRead, NULL);
        ReadFile(hfSource, &CompressedFileSize, sizeof(DWORD), &BytesRead, NULL);
        ReadFile(hfSource, &CreationTime, sizeof(FILETIME), &BytesRead, NULL);
        ReadFile(hfSource, &LastWriteTime, sizeof(FILETIME), &BytesRead, NULL);

        strcpy(FullFileName, TarFolder);
        strcat(FullFileName, PartFileName);

        if(gdwCurrentJobType == JOB_TYPE_EXTRACTSEL)
        {
            int LVItemPos = 0;
            bool SelectedFile = false;

            while((LVItemPos = ListView_GetNextItem(FileList_hWnd, LVItemPos, LVNI_SELECTED)) != -1)
            {
                ListView_GetItemText(FileList_hWnd, LVItemPos, 0, LVFileName, 255);
                ListView_GetItemText(FileList_hWnd, LVItemPos, 8, LVPath, 255);

                if( strcmpi(LVFullFileName, PartFileName) == 0)
                {
                    SelectedFile = true;
                    continue;
                }

                _makepath(LVFullFileName, NULL, LVPath, LVFileName, NULL);
            }

            if(!SelectedFile)
            {
                ReadFile(hfSource, &ReadCRC, sizeof(unsigned long), &BytesRead, NULL);
                SetFilePointer(hfSource, CompressedFileSize-16, NULL, FILE_CURRENT);
                ReadFile(hfSource, &FileNameLen, sizeof(unsigned short), &BytesRead, NULL);
                PackageProgress++;
                continue;
            }
        }

        if(gdwCurrentJobType == JOB_TYPE_CANCEL)
        {
            Sleep(1000);
            break;
        }

        sprintf(StatusText, "Extracting: %s", PartFileName);
        Set_Text(PackingStatusText_hWnd, StatusText);

        CreateFolderStructure(FullFileName);

        hfTarget = CreateFile(
            FullFileName,
            GENERIC_WRITE,
            0,
            NULL,
            CREATE_ALWAYS,
            FILE_ATTRIBUTE_NORMAL,
            NULL
        );

    	FinalCRC = 0xffffffff;

        bool bCompression = true;

        do{
            ReadFile(hfSource, &bCompression, sizeof(bool), &BytesRead, NULL);
            ReadFile(hfSource, &OrigSize, sizeof(DWORD), &BytesRead, NULL);
            ReadFile(hfSource, &DeflSize, sizeof(DWORD), &BytesRead, NULL);
            ReadFile(hfSource, SourceBuf, DeflSize, &BytesRead, NULL);

            InflSize = (BufferSize + ExtraSize);

            SourceBuf[DeflSize] = '\0';
            Decode(&NASCCL, (char *)SourceBuf, (char *)SourceBuf, DeflSize);

            if(bCompression)
            {
        		CompressResult = MyLZSS_Uncompress.GetUncompressedSize(SourceBuf, &InflSize);
                MyLZSS_Uncompress.Uncompress(SourceBuf, TargetBuf);
                FinalCRC = PartialCRC(FinalCRC, TargetBuf, InflSize);
                WriteFile(hfTarget, TargetBuf, InflSize, &BytesWritten, NULL);
            }
            else {
                FinalCRC = PartialCRC(FinalCRC, SourceBuf, BytesRead);
                WriteFile(hfTarget, SourceBuf, BytesRead, &BytesWritten, NULL);
            }

        } while(OrigSize == BufferSize);

        FinalCRC = (FinalCRC ^ 0xffffffff);
        ReadFile(hfSource, &ReadCRC, sizeof(unsigned long), &BytesRead, NULL);

        if(FinalCRC != ReadCRC)
        {
            sprintf(StatusText, "Bad CRC %d should be %d\n%s", FinalCRC, ReadCRC, PartFileName);
            MessageBox(PackingDialog_hWnd, StatusText, gsTitleCaption, MB_ICONEXCLAMATION|MB_OK|MB_APPLMODAL);
            break;
        }

        SetFileTime(hfTarget, &CreationTime, NULL, &LastWriteTime);
        CloseHandle(hfTarget);

        ReadFile(hfSource, &FileNameLen, sizeof(unsigned short), &BytesRead, NULL);
        PackageProgress++;

    } while(BytesRead != 0);

    //--------------------------------------------------------------------------------

    free(SourceBuf);
    free(TargetBuf);

    CloseHandle(hfSource);

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

struct _IconList{
    char Ext[64];
    char Descr[255 + 1];
    int Index;
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool PopGrid(char *SrcName, char *RawKey, int RawKeyLen)
{
    char PartFileName[256];
    char StatusText[1024];
    char TempBuf[1024];
    char TempBuf0[1024];
    DWORD BytesRead = 0;
    DWORD CompressedFileSize = 0;
    DWORD FileCount = 0;
    DWORD FileCountLoop = 0;
    DWORD FileSize = 0;
    FILETIME CreationTime;
    FILETIME LastWriteTime;
    HANDLE hfSource = NULL;
    long Checksum = 0;
    long ReadChecksum1 = 0;
    long ReadChecksum2 = 0;
    unsigned long ReadCRC = 0;
    unsigned short FileNameLen = 0;

    _NASCCL NASCCL;
    LV_ITEM MyLVItem;

    memset(&MyLVItem, 0, sizeof(MyLVItem));
    memset(&NASCCL, 0, sizeof(NASCCL));
    memset(TempBuf, 0, sizeof(TempBuf));

    InitializeCryptographySet(&NASCCL, RawKey, RawKeyLen, CRYPTMETHOD);

    Checksum = MakeChecksum(RawKey);

    hfSource = CreateFile(
        SrcName,
        GENERIC_READ,
        FILE_SHARE_READ,
        NULL,
        OPEN_EXISTING,
        FILE_ATTRIBUTE_NORMAL,
        NULL
    );

    if(hfSource == INVALID_HANDLE_VALUE)
    {
        sprintf(StatusText, "Failed to open '%s' for read.", SrcName);
        MessageBox(ReadingDialog_hWnd, StatusText, gsTitleCaption, MB_ICONEXCLAMATION|MB_OK|MB_APPLMODAL);
        return false;
    }

    ReadFile(hfSource, &ReadChecksum1, sizeof(long), &BytesRead, NULL);
    ReadFile(hfSource, &ReadChecksum2, sizeof(long), &BytesRead, NULL);
    Decode(&NASCCL, (char *)&ReadChecksum2, (char *)&ReadChecksum2, sizeof(long));

    if(ReadChecksum1 != Checksum || ReadChecksum2 != HARDCHECKSUM)
    {
        MessageBox(ReadingDialog_hWnd, "Wrong key, Can't decrypt.", gsTitleCaption, MB_ICONINFORMATION|MB_OK|MB_APPLMODAL);
        CloseHandle(hfSource);
        return false;
    }

    ReadFile(hfSource, &FileCount, sizeof(DWORD), &BytesRead, NULL);
    Decode(&NASCCL, (char *)&FileCount, (char *)&FileCount, sizeof(DWORD));
    SendMessage(ReadingStatusBar_hWnd, PBM_SETRANGE, 0, (LPARAM) MAKELPARAM(0, FileCount));

    //--------------------------------------------------------------------------------

    ReadFile(hfSource, &FileNameLen, sizeof(unsigned short), &BytesRead, NULL);

    HIMAGELIST LV_ImageList = ImageList_Create( GetSystemMetrics(SM_CXSMICON), GetSystemMetrics(SM_CYSMICON), ILC_COLORDDB, 1, 1000);
    ListView_SetImageList(FileList_hWnd, LV_ImageList, LVSIL_SMALL);

    HICON MyIcon = NULL;

    int IconIndexCount = 1;
    _IconList *MyIcoList;
    MyIcoList = (_IconList *) calloc(sizeof(_IconList), 100000);

    MyIcon = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_UNKNOWN));
    ImageList_AddIcon(LV_ImageList, MyIcon);
    DestroyIcon(MyIcon);
    DeleteObject(MyIcon);

/*
    strcpy(MyIcoList[IconIndexCount].Ext, ".exe");
    strcpy(MyIcoList[IconIndexCount].Descr, "Application File");
    MyIcoList[IconIndexCount].Index = IconIndexCount;
    IconIndexCount++;
*/
    do {
        ReadFile(hfSource, PartFileName, FileNameLen, &BytesRead, NULL);
        Decode(&NASCCL, PartFileName, PartFileName, FileNameLen);
    	PartFileName[FileNameLen] = '\0';
        ReadFile(hfSource, &FileSize, sizeof(DWORD), &BytesRead, NULL);
        ReadFile(hfSource, &CompressedFileSize, sizeof(DWORD), &BytesRead, NULL);
        ReadFile(hfSource, &CreationTime, sizeof(FILETIME), &BytesRead, NULL);
        ReadFile(hfSource, &LastWriteTime, sizeof(FILETIME), &BytesRead, NULL);

        SetFilePointer(hfSource, CompressedFileSize-16, NULL, FILE_CURRENT);

        ReadFile(hfSource, &ReadCRC, sizeof(unsigned long), &BytesRead, NULL);

        char Directory[255];
        char FileName[255];
        char Ext[255];
        _splitpath(PartFileName, NULL, Directory, FileName, Ext);
        
		int ImageIndex = -1;

        char Descr[255 + 1];

        int IconSCount = 0;
        while(IconSCount < IconIndexCount)
        {
            if( strcmpi(MyIcoList[IconSCount].Ext, Ext) == 0)
            {
                ImageIndex = IconSCount;
                strcpy(Descr, MyIcoList[IconSCount].Descr);
				break;
            }
            IconSCount++;
        }
	
		if(ImageIndex == -1)
        {
    		char IconFile[255 + 1];
    		int IconIndex = 0;

    		if(GetIconForExt(Ext, IconFile, &IconIndex, Descr))
            {
                if(strlen(IconFile) > 0)
                {
                    MyIcon = NULL;
					ExtractIconEx(IconFile, IconIndex, NULL, &MyIcon, 1);

                    if(MyIcon)
                    {
                        int xIndex = ImageList_AddIcon(LV_ImageList, MyIcon);

						if(xIndex != -1)
                        {
                            DestroyIcon(MyIcon);
                            DeleteObject(MyIcon);

                            strcpy(MyIcoList[IconSCount].Ext, Ext);
                            strcpy(MyIcoList[IconSCount].Descr, Descr);
							MyIcoList[IconSCount].Index = xIndex;

                            ImageIndex = xIndex;

                            IconIndexCount++;
                        }
                    }
                }
            }
        }

        if(ImageIndex == -1)
        {
			sprintf(Descr, "%s File", strupr(Ext));
			ImageIndex = 0;
		}

        sprintf(TempBuf, "%s%s", FileName, Ext);
        MyLVItem.pszText  = TempBuf;
        MyLVItem.mask     = LVIF_TEXT|LVIF_IMAGE;
        MyLVItem.iImage   = ImageIndex;
        MyLVItem.iSubItem = 0;
        ListView_InsertItem(FileList_hWnd, &MyLVItem);

        MyLVItem.pszText  = Descr; // Type
        MyLVItem.mask     = LVIF_TEXT;
        MyLVItem.iSubItem = 1;
        ListView_SetItem(FileList_hWnd, &MyLVItem);

        char TimeTemp[64];
        char DateTemp[64];

        SYSTEMTIME MyST;
        FILETIME lFT;
        FileTimeToLocalFileTime(&LastWriteTime, &lFT);
        if(FileTimeToSystemTime(&lFT, &MyST))
        {
            GetTimeFormat(LOCALE_USER_DEFAULT, TIME_NOSECONDS, &MyST, NULL, TimeTemp, 64);
            GetDateFormat(NULL, NULL, &MyST, "MM-dd-yyyy", DateTemp, 64);
            sprintf(TempBuf, "%s %s", DateTemp, TimeTemp);
        }
        else strcpy(TempBuf, "n/a");
        MyLVItem.pszText  = TempBuf; // Modified
        MyLVItem.mask     = LVIF_TEXT;
        MyLVItem.iSubItem = 2;
        ListView_SetItem(FileList_hWnd, &MyLVItem);

        sprintf(TempBuf, "%d", FileSize);
        MyLVItem.pszText  = FormatiString(TempBuf0, TempBuf); // Size
        MyLVItem.mask     = LVIF_TEXT;
        MyLVItem.iSubItem = 3;
        ListView_SetItem(FileList_hWnd, &MyLVItem);

        if(CompressedFileSize != 0 && FileSize != 0 && FileSize > CompressedFileSize)
        {
            float fCompressedFileSize = (float) CompressedFileSize;
            float fFileSize = (float) FileSize;
            float Ratio = 100 - ((fCompressedFileSize/fFileSize) * 100);
            sprintf(TempBuf, "%.2f%%", Ratio);
        }
        else strcpy(TempBuf, "0.00%");
        MyLVItem.pszText  = TempBuf; // Ratio
        MyLVItem.mask     = LVIF_TEXT;
        MyLVItem.iSubItem = 4;
        ListView_SetItem(FileList_hWnd, &MyLVItem);

        sprintf(TempBuf, "%d", CompressedFileSize);
        MyLVItem.pszText  = FormatiString(TempBuf0, TempBuf); // Packed
        MyLVItem.mask     = LVIF_TEXT;
        MyLVItem.iSubItem = 5;
        ListView_SetItem(FileList_hWnd, &MyLVItem);

        sprintf(TempBuf, "%x", ReadCRC);
        MyLVItem.pszText  = TempBuf; // CRC
        MyLVItem.mask     = LVIF_TEXT;
        MyLVItem.iSubItem = 6;
        ListView_SetItem(FileList_hWnd, &MyLVItem);

        MyLVItem.pszText  = "Attributes"; // Attributes
        MyLVItem.mask     = LVIF_TEXT;
        MyLVItem.iSubItem = 7;
        ListView_SetItem(FileList_hWnd, &MyLVItem);

        MyLVItem.pszText  = Directory; // Path
        MyLVItem.mask     = LVIF_TEXT;
        MyLVItem.iSubItem = 8;
        ListView_SetItem(FileList_hWnd, &MyLVItem);

        ReadFile(hfSource, &FileNameLen, sizeof(unsigned short), &BytesRead, NULL);

        FileCountLoop++;
        PackageProgress = FileCountLoop;

        if(gdwCurrentJobType == JOB_TYPE_CANCEL)
        {
            Sleep(1000);
            break;
        }

    } while(BytesRead != 0 && !(FileNameLen <= 0 || FileNameLen > 255));

    CloseHandle(hfSource);

    //ImageList_Destroy(LV_ImageList);

    if(FileNameLen <= 0 || FileNameLen > 255)
    {
        sprintf(StatusText, "Corrupt data file. Name length: %d", FileNameLen);
        MessageBox(ReadingDialog_hWnd, StatusText, gsTitleCaption, MB_ICONEXCLAMATION|MB_OK|MB_APPLMODAL);

        return false;
    }

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI ExtractEntireArchive_Worker_Thread(LPVOID xData)
{
    char *CmdLine = (char *) xData;

    while(!IsWindowVisible(PackingDialog_hWnd))
    {
        Sleep(1);
    }

    if(IsWindow(MainDialog_hWnd))
    {
        SetForegroundWindow(MainDialog_hWnd);
    }

    Set_Text(PackingStatusText_hWnd, "Please wait...");
    Sleep(100);

    if(BreakPackage(CmdLine, gsExtractLocation, gsPassword, strlen(gsPassword)))
    {
        if(gdwCurrentJobType == JOB_TYPE_CANCEL)
        {
            Set_Text(PackingStatusText_hWnd, "Cancelled.");
            Sleep(1000);
        }
        else{
            Set_Text(PackingStatusText_hWnd, "Done.");
            Sleep(100);
        }

        PackageProgress = 0;
        gdwCurrentJobType = 0;
        EndDialog(PackingDialog_hWnd, 1);

        return 0;
    }
    else{
        if(gdwCurrentJobType == JOB_TYPE_CANCEL)
        {
            Set_Text(PackingStatusText_hWnd, "Cancelled.");
        }

        Sleep(1000);

        PackageProgress = 0;
        gdwCurrentJobType = 0;
        EndDialog(PackingDialog_hWnd, 1);

        return 0;
    }

	return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI ViewExisting_Worker_Thread(LPVOID xData)
{
    char *CmdLine = (char *) xData;

    while(!IsWindowVisible(ReadingDialog_hWnd))
    {
        Sleep(1);
    }

    if(IsWindow(MainDialog_hWnd))
    {
        SetForegroundWindow(MainDialog_hWnd);
    }

    Set_Text(ReadingStatusText_hWnd, "Please wait... Decrypting the archive.");
    Sleep(100);

    if(PopGrid(CmdLine, gsPassword, strlen(gsPassword)))
    {
        if(gdwCurrentJobType == JOB_TYPE_CANCEL)
        {
            Set_Text(ReadingStatusText_hWnd, "Cancelled.");
            Sleep(1000);
            PackageProgress = 0;
            gdwCurrentJobType = 0;
            EndDialog(ReadingDialog_hWnd, 0);
        }
        else{
            Set_Text(ReadingStatusText_hWnd, "Done.");
            Sleep(250);
            PackageProgress = 0;
            gdwCurrentJobType = 0;
            EndDialog(ReadingDialog_hWnd, 1);
        }

        return 0;
    }
    else{
        if(gdwCurrentJobType == JOB_TYPE_CANCEL)
        {
            Set_Text(ReadingStatusText_hWnd, "Cancelled.");
        }

        Sleep(1000);
        PackageProgress = 0;
        gdwCurrentJobType = 0;
        EndDialog(ReadingDialog_hWnd, 0);

        return 0;
    }

	return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI CreateNewDirArchive_Worker_Thread(LPVOID xData)
{
    char *CmdLine = (char *) xData;

    while(!IsWindowVisible(PackingDialog_hWnd))
    {
        Sleep(1);
    }

    if(IsWindow(MainDialog_hWnd))
    {
        SetForegroundWindow(MainDialog_hWnd);
    }

    Set_Text(PackingStatusText_hWnd, "Please wait...");
    Sleep(100);

    if(MakePackage(CmdLine, gsWorkingOutput, gsPassword, strlen(gsPassword)))
    {
        if(gdwCurrentJobType == JOB_TYPE_CANCEL)
            Set_Text(PackingStatusText_hWnd, "Cancelled.");
        else Set_Text(PackingStatusText_hWnd, "Done.");

        PackageProgress = 0;
        gdwCurrentJobType = 0;

        Sleep(1000);
        EndDialog(PackingDialog_hWnd, 1);

        strcpy(gsWorkingInput, gsWorkingOutput);

        return 0;
    }
    else{
        if(gdwCurrentJobType == JOB_TYPE_CANCEL)
            Set_Text(PackingStatusText_hWnd, "Cancelled.");

        PackageProgress = 0;
        gdwCurrentJobType = 0;

        Sleep(1000);
        EndDialog(PackingDialog_hWnd, 0);

        return 0;
    }

	return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
